#ifndef QRFESLEEPER_H_
#define QRFESLEEPER_H_

#include <QCoreApplication>
#include <QThread>

class QrfeSleeper : public QThread
{
	Q_OBJECT

public:
	/*!
	 * @brief Simple function to sleep for the given milli seconds.
	 * @param	msecs		Milliseconds to sleep
	 */
	static void MSleep ( unsigned long msecs );

	/*!
	 * @brief Simple function to sleep active for the given milli seconds.
	 * The function does not sleep deep, so everything in the thread is blocked, it sleeps for 1 msec and then processes
	 * the event loop with the given flags. This is done until the given msecs elapsed.
	 * @param	msecs		Milliseconds to sleep
	 * @param 	flags		Flags which events should be processed
	 */
	static void MSleepAlive ( unsigned long msecs, QEventLoop::ProcessEventsFlags flags = QEventLoop::AllEvents );

private:
	virtual void run();
};


#endif /*QRFESLEEPER_H_*/
